<?php
/**
 * Uninstall Disable Right Click and Text Selection
 *
 * @package DRC
 * @author sarusadgac
 * @version 2.0
 */

// Exit if accessed directly
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

/**
 * Clean up all plugin data
 */
global $wpdb;

// Remove plugin options (settings & related transients)
delete_option('drc_settings');
delete_transient('drc_plugin_settings');

// Bulk delete any post meta that starts with our prefix (defensive future-proofing)
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
$wpdb->query( "DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE 'drc\\_%'" );

// Optional: remove user meta if ever used in future versions (safe no-op if none)
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
$wpdb->query( "DELETE FROM {$wpdb->usermeta} WHERE meta_key LIKE 'drc\\_%'" );

// Flush object cache if present
if ( function_exists('wp_cache_flush') ) {
    wp_cache_flush();
}
