/**
 * @author sarusadgac
 * @description Disable right click and text selection functionality
 */

// Accessible non-blocking toast implementation
(function(){
    var lastShown=0; // throttle
    function ensureToastContainer(){
        var id='drc-toast-container';
        var el=document.getElementById(id);
        if(el)return el; 
        el=document.createElement('div');
        el.id=id;
        el.setAttribute('aria-live','polite');
        el.setAttribute('aria-atomic','true');
        el.style.position='fixed';
        el.style.zIndex='99999';
        el.style.bottom='1rem';
        el.style.right='1rem';
        el.style.maxWidth='320px';
        el.style.fontFamily='system-ui,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Ubuntu,sans-serif';
        el.style.pointerEvents='none';
        document.body.appendChild(el);
        return el;
    }
    function showToast(msg){
        var now=Date.now();
        if(now-lastShown<1500){return;} // throttle repeated right clicks
        lastShown=now;
        var wrap=document.createElement('div');
        wrap.style.background='rgba(0,0,0,.85)';
        wrap.style.color='#fff';
        wrap.style.padding='8px 12px';
        wrap.style.marginTop='8px';
        wrap.style.borderRadius='4px';
        wrap.style.boxShadow='0 2px 6px rgba(0,0,0,.4)';
        wrap.style.fontSize='13px';
        wrap.style.lineHeight='1.4';
        wrap.style.transition='opacity .4s ease';
        wrap.textContent=msg;
        var container=ensureToastContainer();
        container.appendChild(wrap);
        requestAnimationFrame(function(){wrap.style.opacity='1';});
        setTimeout(function(){wrap.style.opacity='0'; setTimeout(function(){wrap.remove();},400);},3000);
    }
    document.addEventListener('contextmenu',function(e){
        if(typeof drcLocalized!=='undefined' && drcLocalized.message){
            showToast(drcLocalized.message);
        }
        e.preventDefault();
    });
})();
