<?php
/** Frontend asset loading */
if (!defined('ABSPATH')) { exit; }

function drc_should_load_assets() {
    static $cache=null; if($cache!==null){ return $cache; }
    if (is_admin()) { return $cache=false; }
    $settings = drc_get_settings();
    $post_id = get_queried_object_id();
    $is_singular_view = is_singular();
    $user = wp_get_current_user();
    if (in_array('administrator', (array)$user->roles, true)) { return $cache=false; }
    $is_guest = empty($user->roles);
    if ($is_guest && !in_array('guest', (array)$settings['disable_for_roles'], true)) { return $cache=false; }
    if (!$is_guest) {
        if (empty(array_intersect((array)$user->roles, (array)$settings['disable_for_roles']))) { return $cache=false; }
    }
    if ($is_singular_view && $post_id) {
        $flags = drc_get_post_flags($post_id); if ($flags) { return $cache=true; }
    }
    $context_pt = $is_singular_view ? get_post_type($post_id) : 'post';
    if (empty($settings['disable_on_post_types']) || !in_array($context_pt, (array)$settings['disable_on_post_types'], true)) {
        if ((is_front_page() || is_home()) && (!empty($settings['disable_right_click']) || !empty($settings['disable_text_selection']))) { return $cache=true; }
        return $cache=false; }
    return $cache = (!empty($settings['disable_right_click']) || !empty($settings['disable_text_selection']));
}

function drc_enqueue_scripts() {
    if (!drc_should_load_assets()) { return; }
    $asset_version = defined('WP_DEBUG') && WP_DEBUG ? time() : DRC_VERSION;
    $post_id = get_queried_object_id();
    $settings = drc_get_settings();
    $flags = drc_get_post_flags($post_id);
    $disable_rc = drc_flag_enabled($flags, DRC_FLAG_RIGHT_CLICK) || (!$flags && !empty($settings['disable_right_click']));
    $disable_ts = drc_flag_enabled($flags, DRC_FLAG_TEXT_SELECTION) || (!$flags && !empty($settings['disable_text_selection']));
    $message = drc_get_post_message($post_id, $settings);
    if ($disable_rc) {
        wp_enqueue_script('drc-script', DRC_PLUGIN_URL . 'js/drc-script.js', [], $asset_version, ['in_footer'=>true,'strategy'=>'defer','precache'=>true]);
        wp_localize_script('drc-script','drcLocalized',[ 'message'=>esc_html($message) ]);
    }
    if ($disable_ts) {
        wp_enqueue_style('drc-style', DRC_PLUGIN_URL . 'css/drc-style.css', [], $asset_version, 'all');
    }
}
add_action('wp_enqueue_scripts','drc_enqueue_scripts');

function drc_is_text_selection_disabled($post_id=null){
    $settings = drc_get_settings();
    if(!is_singular()){ if(is_front_page()||is_home()) { return !empty($settings['disable_text_selection']); } return false; }
    if($post_id===null){ $post_id=get_queried_object_id(); }
    if(!$post_id){ return false; }
    $flags=drc_get_post_flags($post_id); if($flags){ return drc_flag_enabled($flags, DRC_FLAG_TEXT_SELECTION); }
    $pt=get_post_type($post_id); if(!in_array($pt,(array)$settings['disable_on_post_types'],true)){ return false; }
    return !empty($settings['disable_text_selection']);
}

function drc_body_class($classes){ if(drc_is_text_selection_disabled()){ $classes[]='drc-no-select'; } return $classes; }
add_filter('body_class','drc_body_class');
