<?php
/** Admin settings registration & sanitizer */
if(!defined('ABSPATH')){ exit; }

class DRC_Settings_Sanitizer {
    public static function sanitize($input){
        $output=[];
        $output['disable_right_click'] = !empty($input['disable_right_click']) ? 1 : 0;
        $output['disable_text_selection'] = !empty($input['disable_text_selection']) ? 1 : 0;
        $output['disable_on_post_types'] = array_filter(array_map('sanitize_text_field', isset($input['disable_on_post_types'])?(array)$input['disable_on_post_types']:[]));
    $roles = isset($input['disable_for_roles']) ? (array)$input['disable_for_roles'] : [];
    $valid_roles = array_merge(['guest'], array_keys(get_editable_roles()));
    $filtered = array_values(array_intersect($roles, $valid_roles));
    // Ensure administrator is not stored (always excluded in logic anyway)
    $filtered = array_values(array_diff($filtered, ['administrator']));
    $output['disable_for_roles'] = $filtered;
        $message = isset($input['right_click_message']) ? wp_kses_post($input['right_click_message']) : '';
        $output['right_click_message'] = mb_substr($message,0,200);
        return $output;
    }
}

function drc_settings_init(){
    register_setting('drc_settings_group','drc_settings',[ 'sanitize_callback'=>['DRC_Settings_Sanitizer','sanitize']]);

    add_settings_section('drc_main_section',__('Protection Settings','disable-right-click-and-select'),function(){
        echo '<p>'.esc_html__('Configure right click and text selection restrictions.','disable-right-click-and-select').'</p>';
    },'drc_settings');

    add_settings_field('drc_disable_right_click',__('Disable Right Click','disable-right-click-and-select'),'drc_field_disable_right_click','drc_settings','drc_main_section');
    add_settings_field('drc_disable_text_selection',__('Disable Text Selection','disable-right-click-and-select'),'drc_field_disable_text_selection','drc_settings','drc_main_section');
    add_settings_field('drc_disable_on_post_types',__('Apply To Post Types','disable-right-click-and-select'),'drc_field_disable_on_post_types','drc_settings','drc_main_section');
    add_settings_field('drc_disable_for_roles',__('Apply To Roles','disable-right-click-and-select'),'drc_field_disable_for_roles','drc_settings','drc_main_section');
    add_settings_field('drc_right_click_message',__('Right Click Message','disable-right-click-and-select'),'drc_field_right_click_message','drc_settings','drc_main_section');
}
add_action('admin_init','drc_settings_init');

function drc_get_settings_fields_values(){ return drc_get_settings(); }

function drc_field_disable_right_click(){
    $s=drc_get_settings_fields_values();
    echo '<label><input type="checkbox" name="drc_settings[disable_right_click]" value="1" '.checked(!empty($s['disable_right_click']),true,false).'/>
        '.esc_html__('Disable right click','disable-right-click-and-select').'</label>';
}
function drc_field_disable_text_selection(){
    $s=drc_get_settings_fields_values();
    echo '<label><input type="checkbox" name="drc_settings[disable_text_selection]" value="1" '.checked(!empty($s['disable_text_selection']),true,false).'/>
        '.esc_html__('Disable text selection','disable-right-click-and-select').'</label>';
}
function drc_field_disable_on_post_types(){
    $s=drc_get_settings_fields_values();
    $pts=get_post_types(['public'=>true],'objects');
    $size = (int) min(8, count($pts));
    echo '<select name="drc_settings[disable_on_post_types][]" multiple size="'.esc_attr($size).'" style="min-width:220px;">';
    foreach($pts as $pt){
        echo '<option value="'.esc_attr($pt->name).'" '.selected(in_array($pt->name,(array)$s['disable_on_post_types'],true),true,false).'>'.esc_html($pt->labels->singular_name).'</option>';
    }
    echo '</select><p class="description">'.esc_html__('Hold CTRL / CMD to select multiple.','disable-right-click-and-select').'</p>';
}
function drc_field_disable_for_roles(){
    $s=drc_get_settings_fields_values();
    $roles=get_editable_roles();
    // Build options: guest + all editable roles except administrator
    $options = ['guest' => __('Guest (Non-Logged In Users)','disable-right-click-and-select')];
    foreach($roles as $key=>$role){ if($key==='administrator'){ continue; } $options[$key]=$role['name']; }
    $size = (int) min(8, count($options));
    echo '<select name="drc_settings[disable_for_roles][]" multiple size="'.esc_attr($size).'" style="min-width:220px;">';
    foreach($options as $key=>$label){
        echo '<option value="'.esc_attr($key).'" '.selected(in_array($key,(array)$s['disable_for_roles'],true),true,false).'>'.esc_html($label).'</option>';
    }
    echo '</select><p class="description">'.esc_html__('Select roles the protection applies to. Administrators are always excluded.','disable-right-click-and-select').'</p>';
}
function drc_field_right_click_message(){
    $s=drc_get_settings_fields_values();
    $count = (int) strlen((string) $s['right_click_message']);
    echo '<textarea id="drc_right_click_message" name="drc_settings[right_click_message]" rows="3" cols="50" maxlength="200">'.esc_textarea($s['right_click_message']).'</textarea>';
    echo '<p><span id="drc_message_counter">'.esc_html($count).'/200</span></p>';
}

function drc_add_admin_menu(){
    add_options_page(__('Disable Right Click','disable-right-click-and-select'),__('Disable Right Click','disable-right-click-and-select'),'manage_options','drc_settings','drc_render_settings_page');
}
add_action('admin_menu','drc_add_admin_menu');

// Legacy slug redirect for backward compatibility (old slug: disable-right-click)
function drc_legacy_settings_slug_redirect(){
    if (!is_admin()) { return; }
    if (isset($_GET['page']) && $_GET['page'] === 'disable-right-click') { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $target = admin_url('options-general.php?page=drc_settings');
        if (!headers_sent()) { wp_safe_redirect($target,301); exit; }
        echo '<script>location.href='.json_encode($target).';</script>';
    }
}
add_action('admin_init','drc_legacy_settings_slug_redirect');

function drc_render_settings_page(){
    echo '<div class="wrap"><h1>'.esc_html__('Disable Right Click & Selection','disable-right-click-and-select').'</h1><form method="post" action="options.php">';
    settings_fields('drc_settings_group');
    do_settings_sections('drc_settings');
    submit_button();
    echo '</form></div>';
}
