<?php
/**
 * Plugin Name: Disable Right Click and Text Selection
 * Plugin URI: https://httpdocs.org/disable-right-click-and-select
 * Description: Disable right click and text selection on your WordPress site with advanced options.
 * Version: 2.4.1
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * Tested up to: 6.8
 * Author: sarusadgac
 * Author URI: https://httpdocs.org
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: disable-right-click-and-select
 * Domain Path: /languages
 *
 * @package DRC
 * @since 1.0.0 Initial release
 * @since 2.0.0 Major version update with significant improvements
 * @since 2.1.0 Added complete translations and language improvements
 * @since 2.2.0 Performance improvements and bug fixes
 */

// Prevent direct file access
if (!defined('ABSPATH')) {
    exit;
}

// PHP version check
if (version_compare(PHP_VERSION, '7.4', '<')) {
    deactivate_plugins(plugin_basename(__FILE__));
    wp_die(esc_html__('This plugin requires PHP 7.4 or higher.', 'disable-right-click-and-select'));
}

// Define plugin constants
if (!defined('DRC_VERSION')) { define('DRC_VERSION', '2.4.1'); }
if (!defined('DRC_PLUGIN_FILE')) { define('DRC_PLUGIN_FILE', __FILE__); }
if (!defined('DRC_PLUGIN_DIR')) {
    define('DRC_PLUGIN_DIR', plugin_dir_path(__FILE__));
}
if (!defined('DRC_PLUGIN_URL')) {
    define('DRC_PLUGIN_URL', plugin_dir_url(__FILE__));
}
if (!defined('DRC_MIN_WP_VERSION')) {
    define('DRC_MIN_WP_VERSION', '5.8');
}

// New modular includes
require_once DRC_PLUGIN_DIR . 'includes/Core/Bootstrap.php';
require_once DRC_PLUGIN_DIR . 'includes/Admin/Settings.php';
require_once DRC_PLUGIN_DIR . 'includes/Frontend/Assets.php';
require_once DRC_PLUGIN_DIR . 'includes/class-drc-post-meta.php';
require_once DRC_PLUGIN_DIR . 'includes/class-drc-post-list.php';

// Admin inline enhancement retained (kept separate from settings registration for clarity)
function drc_admin_assets($hook){
    if ($hook !== 'settings_page_drc_settings') { return; }
    wp_add_inline_script('jquery-core',"(function(){var f=document.getElementById('drc_right_click_message');if(!f)return;var c=document.getElementById('drc_message_counter');if(!c)return;var u=function(){c.textContent=f.value.length+'/200';};u();f.addEventListener('input',u);})();");
}
add_action('admin_enqueue_scripts','drc_admin_assets');

// Silence is golden now; all logic dispatched to modules above.
